(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17552,        523]*)
(*NotebookOutlinePosition[     19099,        568]*)
(*  CellTagsIndexPosition[     19055,        564]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Integrales de superficie. Teoremas de la divergencia y de Stokes\
\>", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada
\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Integrales de superficie", "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Para cada una de las siguientes superficies calcula un vector normal \
unitario en un punto gen\[EAcute]rico de la superficie, el plano tangente en \
el punto que se indica en cada caso y representa gr\[AAcute]ficamente (una \
parte de) la superficie junto con la recta normal y el plano tangente en el \
punto indicado. \na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{
            RowBox[{"u", " ", "cos", " ", "v", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"u", " ", "sen", " ", "v", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((1 - u\^2)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] u \[LessEqual] 1, \ 
      0 \[LessEqual] v \[LessEqual] 2  \[Pi]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \[Gamma](1/\@2, \[Pi]/2)\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{
            RowBox[{\(\@2\), "sen", " ", "u", " ", "cos", " ", "v", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{
            "2", \(\@2\), "sen", " ", "u", " ", "sen", " ", "v", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{\(\@3\), "cos", " ", "u", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] u \[LessEqual] \[Pi], \ 
      0 \[LessEqual] v \[LessEqual] 2  \[Pi]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((1/2, 1, 3/2)\)\)]],
  ".\nc) ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](u, v) = \((2  u + 2  v, u - v, u\ v)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] u \[LessEqual] 1, \ 
      \(-1\) \[LessEqual] v \[LessEqual] 1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((2, 0, 1/4)\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell["\<\
a1) Define un comando que calcule simb\[OAcute]licamente integrales de \
superficie de campos escalares. La sintaxis de este comando debe ser de la \
forma \"integsuperficie[func][super,{s,smin,smax},{t,tmin,tmax}]\", donde \
debes suponer que \"func\" es el nombre de una funci\[OAcute]n conocida de \
tres variables y \"super\" es el nombre de la funci\[OAcute]n que nos da la \
superficie en forma param\[EAcute]trica para valores de los \
par\[AAcute]metros en el rect\[AAcute]ngulo [smin,smax]\[Times][tmin,tmax].
Aqu\[IAcute] tienes un ejemplo de lo que debe ser capaz de hacer tu comando (\
\[DownExclamation]no ejecutes la celda!).\
\>", "ExerciseText"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(f[x_, y_, z_] = x + y + z; \  (*\ el\ campo\ escalar\ *) \n
    \[Gamma][s_, t_] = {t, s, t + s}; 
    \  (*\ 0 \[LessEqual] s, 
      t \[LessEqual] 1\ la\ superficie\ de\ integraci\[OAcute]n\ *) \n
    \(integsuperficie[f]\)[\[Gamma], {s, 0, 1}, {t, 0, 1}] (*\ 
      este\ es\ el\ comando\ que\ t\[UAcute]\ debes\ definir\ y\ tiene\ que\ 
        calcular\ simb\[OAcute]licamente\ la\ integral\ de\ superficie\ del\ 
        campo\ escalar\ f\ *) \)\)], "Input"],

Cell[BoxData[
    \(2\ \@3\)], "Output"]
}, Open  ]],

Cell["\<\
a2) Para el caso en que la funci\[OAcute]n \"super\" est\[EAcute] definida en \
un sector de una corona circular, modifica el comando definido en el apartado \
anterior para que calcule la integral en coordenadas polares.\
\>", "ExerciseText"],

Cell[TextData[{
  "b) Usa el comando que has definido para calcular las integrales de los \
campos escalares ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en las superficies dadas:\nb1) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 
        x + y + z, \ \[Gamma](s, t) = \((s, t, s + t)\), \ 0 \[LessEqual] s, 
      t \[LessEqual] 1\)]],
  ".\nb2) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 
        x\^2 + y\^2 + z, \ \[Gamma](s, t) = \((sen\ t\ cos\ s, 
          sen\ t\ sen\ s, cos\ t)\), \ \ 0 \[LessEqual] 
        s, \(\(t\)\(\[LessEqual]\)\(\[Pi]\)\(\ \)\)\)]],
  ".\nb3) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 
        x\ z, \[Gamma](s, t) = \((s, t, 
          1 - s\^2 - t\^2)\), \ \ 0 \[LessEqual] s, t \[LessEqual] 1\)]],
  ".\nb4) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = \(x\^2\) y + z\^2\)]],
  " en la superficie formada por la parte del cilindro ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 9\)]],
  " comprendida entre los planos ",
  Cell[BoxData[
      \(TraditionalForm\`z = 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`z = 2\)]],
  ".\nb5) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = y\ z\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](u, v)\), "=", 
          RowBox[{
            RowBox[{"u", " ", "v", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((u + v)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((u - v)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`u\^2 + v\^2 \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Consideremos la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " cuya ecuaci\[OAcute]n en coordenadas esf\[EAcute]ricas es ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] = \[Theta], \ 
      0 \[LessEqual] \[Theta] \[LessEqual] \[Pi]/2, \ 
      0 \[LessEqual] \[Phi] \[LessEqual] \(\(\[Pi]\)\(.\)\)\)]],
  " Para pon\[EAcute]rtelo m\[AAcute]s f\[AAcute]cil, se trata de la \
superficie cuyas ecuaciones param\[EAcute]tricas en coordenadas cartesianas \
son"
}], "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`\[Gamma](\[Theta], \[Phi]) = \(G(\[Theta], \[Theta], \
\[Phi])\)\ \ con\ \ 0 \[LessEqual] \[Theta] \[LessEqual] \[Pi]/2, \ 
    0 \[LessEqual] \[Phi] \[LessEqual] \[Pi], \)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`G(\[Rho], \[Theta], \[Phi]) = \((\[Rho]\ cos\ \[Phi]\
\ sen\ \[Theta], \ \[Rho]\ sen\ \[Phi]\ sen\ \[Theta], \ \[Rho]\ cos\ \
\[Theta])\)\)]],
  " es la conocida funci\[OAcute]n que introduce las cordenadas \
esf\[EAcute]ricas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ".\na) Representa la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " junto con las rectas que pasan por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](\[Pi]/6, \[Pi]/2)\)]],
  " con vectores de direcci\[OAcute]n dados por ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]\[Gamma]\/\[PartialD]\[Theta]\) \
\((\[Pi]/6, \[Pi]/2)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]\[Gamma]\/\[PartialD]\[Phi]\) \((\[Pi]/
            6, \[Pi]/2)\)\)]],
  ". Representa tambi\[EAcute]n gr\[AAcute]ficamente la recta normal a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " en dicho punto.\nb) Calcula, usando integraci\[OAcute]n num\[EAcute]rica, \
el centroide de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " y representa el centroide en la gr\[AAcute]fica anterior en \
tama\[NTilde]o y color apropiados para que se vea bien. \nSugerencia: Elige \
con ",
  Cell[BoxData[
      \(TraditionalForm\`Input -> 3  DPointViewSelector\)]],
  " un punto de vista adecuado en cada caso."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a1) Define un comando que calcule simb\[OAcute]licamente integrales de \
superficie de campos vectoriales. La sintaxis de este comando debe ser de la \
forma \"vectorintegsuperficie[func][super,{s,smin,smax},{t,tmin,tmax}]\", \
donde debes suponer que \"func\" es el nombre del campo vectorial que se \
integra y \"super\" es el nombre de la funci\[OAcute]n que nos da la \
superficie en forma param\[EAcute]trica para valores de los \
par\[AAcute]metros en el rect\[AAcute]ngulo [smin,smax]\[Times][tmin,tmax]. \
Tambi\[EAcute]n debes suponer que la orientaci\[OAcute]n de la superficie es \
la inducida por la parametrizaci\[OAcute]n dada. \na2) Para el caso en que la \
funci\[OAcute]n \"super\" est\[EAcute] definida en un sector de una corona \
circular, modifica el comando definido en el apartado anterior para que \
calcule la integral en coordenadas polares.\nb) Calcula el flujo del campo \
vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"x", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Plain"], 
            StyleBox["+",
              FontWeight->"Plain"], 
            StyleBox[" ",
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox["y",
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"3", "z", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " a trav\[EAcute]s de la superficie dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Gamma](u, v)\), "=", 
            RowBox[{
              RowBox[{"a", " ", "cos", " ", "u", " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], "+", " ", 
              RowBox[{"a", " ", "sen", " ", "u", " ", 
                StyleBox["j",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["+",
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox["v",
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                StyleBox["k",
                  FontWeight->"Bold"]}]}]}], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox[\(0 \[LessEqual] u \[LessEqual] \[Pi]\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          
          StyleBox[\(\(0\)\(\[LessEqual]\)\(v\)\(\[LessEqual]\)\(\[Pi]\)\(\ \
\)\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  ".\nc) Calcula la integral del campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y, z) = \((x, y, z)\)\)]],
  " sobre la superficie de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`z = \@\(R\^2 - x\^2 - y\^2\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 \[LessEqual] R\^2\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "Calcula el flujo del campo vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y, z)\), "=", 
          RowBox[{
            RowBox[{\((x\^3 - z\^2 + y\^3)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"x", " ", \(y\^3\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"y", " ", "z", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " a trav\[EAcute]s de la superficie del s\[OAcute]lido acotado por el plano \
XY y la gr\[AAcute]fica de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`h(x, y) = 4 - x\^2 - y\^2\)]],
  ".\na) Directamente mediante una integral de superficie.\nb) Usando el \
teorema de la divergencia."
}], "ExerciseText"],

Cell["\<\
En los siguientes ejercicios puede ser conveniente usar el teorema de Stokes \
o de la divergencia.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " la superficie formada por las cinco caras superiores del cubo ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] x \[LessEqual] 1, 
      0 \[LessEqual] y \[LessEqual] 1, 0 \[LessEqual] z \[LessEqual] 1\)]],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y, z) = \((x\ y, \ 0, \ \(-z\^2\))\)\)]],
  ". Calcula el flujo saliente del campo ",
  Cell[BoxData[
      \(TraditionalForm\`rot\ F\)]],
  " a trav\[EAcute]s de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Se considera el s\[OAcute]lido ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " limitado por la superficie cil\[IAcute]ndrica ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 2  y\)]],
  " y los planos ",
  Cell[BoxData[
      \(TraditionalForm\`z = 0, \ y + z = 2\)]],
  ". Calcular el flujo saliente del campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm
      \`F(x, y, z) = 
        \((x\^2 + sen\ z, \ x\ y\  + \ cos\ z, \ \[ExponentialE]\^y)\)\)]],
  " a trav\[EAcute]s de la superficie frontera ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  "Calcular la integral de l\[IAcute]nea ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_\[Gamma]\(-y\) \[DifferentialD]x + 
        \(x\^3\) \[DifferentialD]y - \(z\^3\) \[DifferentialD]z\)]],
  " donde \[Gamma] es la curva intersecci\[OAcute]n del cilindro ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 1\)]],
  " con el plano ",
  Cell[BoxData[
      \(TraditionalForm\`x + y + z = 1\)]],
  " y la orientaci\[OAcute]n de \[Gamma] es en sentido antihorario."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "Sea \[Gamma] la curva intersecci\[OAcute]n de las superficies de \
ecuaciones ",
  Cell[BoxData[
      \(TraditionalForm\`z = 50 - x\^2 - \((y - 6)\)\^2\)]],
  "  y  ",
  Cell[BoxData[
      \(TraditionalForm\`z = \ x\^2 + y\^2\)]],
  ". Justifica que \[Gamma] se encuentra situada en un plano y expresa \
\[Gamma] por medio de ecuaciones param\[EAcute]tricas que la describan en \
sentido antihorario cuando se la v\[EAcute] desde arriba. Calcula la \
circulaci\[OAcute]n del campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y, z) = \((2  x\ z - z\^2, y\^2 - 2\ x\ y, \ 
          y\ z)\)\)]],
  " a lo largo de \[Gamma] de tres formas distintas:\na) Aplicando \
directamente la definici\[OAcute]n.\nb) Aplicando el teorema de Stokes a la \
parte del plano acotada por \[Gamma].\nc) Aplicando el teorema de Stokes a la \
parte de la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`z = \(\(x\^2\)\(+\)\(y\^2\)\(\ \)\)\)]],
  "acotada por \[Gamma]."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, 2},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Integrales de superficie. Teoremas de la divergencia y de Stokes"], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Integrales de superficie. Teoremas de la divergencia y de Stokes"], 
        "Header"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 89, 2, 174, "Title"],
Cell[1846, 55, 189, 7, 130, "Author"],

Cell[CellGroupData[{
Cell[2060, 66, 43, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[2128, 70, 31, 0, 68, "Exercise"],
Cell[2162, 72, 2160, 59, 195, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4359, 136, 31, 0, 68, "Exercise"],
Cell[4393, 138, 671, 10, 153, "ExerciseText"],

Cell[CellGroupData[{
Cell[5089, 152, 487, 8, 176, "Input"],
Cell[5579, 162, 40, 1, 74, "Output"]
}, Open  ]],
Cell[5634, 166, 253, 4, 67, "ExerciseText"],
Cell[5890, 172, 1781, 54, 237, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7708, 231, 31, 0, 68, "Exercise"],
Cell[7742, 233, 518, 12, 67, "ExerciseText"],
Cell[8263, 247, 244, 4, 38, "Text"],
Cell[8510, 253, 1447, 37, 229, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9994, 295, 31, 0, 68, "Exercise"],
Cell[10028, 297, 3376, 86, 325, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13441, 388, 31, 0, 68, "Exercise"],
Cell[13475, 390, 836, 21, 135, "ExerciseText"],
Cell[14314, 413, 123, 3, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14474, 421, 31, 0, 68, "Exercise"],
Cell[14508, 423, 591, 18, 67, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15136, 446, 31, 0, 68, "Exercise"],
Cell[15170, 448, 678, 22, 67, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15885, 475, 31, 0, 68, "Exercise"],
Cell[15919, 477, 524, 13, 71, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16480, 495, 31, 0, 68, "Exercise"],
Cell[16514, 497, 1010, 22, 221, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

